<?php
session_start();
include "../includes/db.php";

$message = '';
$expiry_seconds = 300; // 5 min

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $otp = $_POST['otp1'].$_POST['otp2'].$_POST['otp3'].$_POST['otp4'].$_POST['otp5'].$_POST['otp6'];

    // ✅ Correct session keys
    if (!isset($_SESSION['reset_otp'], $_SESSION['otp_time'], $_SESSION['reset_email'])) {
        $message = "Session expired. Please request OTP again.";
    } 
    elseif (time() - $_SESSION['otp_time'] > $expiry_seconds) {
        $message = "OTP expired. Please request a new one.";
        session_unset();
        session_destroy();
    } 
    elseif ($otp == $_SESSION['reset_otp']) {
        $message = "OTP verified successfully!";

        // Cleanup
        unset($_SESSION['reset_otp']);
        unset($_SESSION['otp_time']);

        echo "<script>
            setTimeout(() => {
                window.location.href = 'reset_password.php';
            }, 1500);
        </script>";
    } 
    else {
        $message = "Incorrect OTP. Please try again.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Verify OTP</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
 <!-- CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="icon" type="image/png" href="../assets/images/starserver/star-server-favicon.png">
    <!-- Font Awesome 6.5.1 (FREE) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    .otp-inputs input { width: 40px; padding:10px; margin:0 5px; font-size:18px; text-align:center; }
    .otp-message { margin-top:10px; font-weight:bold; color:red; }
    .otp-message.success { color:green; }

    .otp_login {
    display: flex;
    justify-content: center;
    align-items: center;
    margin-top: 20%;
    }
</style>
</head>
<body>
<div class="row">
    <div class="col-md-6">
        <div class="otp_login">
            <form method="POST">
                <h2>OTP Verification</h2>
                <div class="otp-inputs">
                    <input type="text" maxlength="1" name="otp1" id="otp1" oninput="moveNext(this,'otp2')"
                        onkeydown="movePrev(event,'otp1')" required>
                    <input type="text" maxlength="1" name="otp2" id="otp2" oninput="moveNext(this,'otp3')"
                        onkeydown="movePrev(event,'otp1')" required>
                    <input type="text" maxlength="1" name="otp3" id="otp3" oninput="moveNext(this,'otp4')"
                        onkeydown="movePrev(event,'otp2')" required>
                    <input type="text" maxlength="1" name="otp4" id="otp4" oninput="moveNext(this,'otp5')"
                        onkeydown="movePrev(event,'otp3')" required>
                    <input type="text" maxlength="1" name="otp5" id="otp5" oninput="moveNext(this,'otp6')"
                        onkeydown="movePrev(event,'otp4')" required>
                    <input type="text" maxlength="1" name="otp6" id="otp6" onkeydown="movePrev(event,'otp5')" required>
                </div>
                <p>OTP expires in <span id="timer">05:00</span></p>
                <button type="submit">Verify OTP</button>
                <?php if($message != ''): ?>
                <p class="otp-message <?= ($message==='OTP verified successfully!')?'success':'' ?>">
                    <?= htmlspecialchars($message) ?>
                </p>
                <?php endif; ?>
            </form>
        </div>
    </div>

    <div class="col-md-6">
            <div class="star_col">
                <div class="col_box">
                    <h1>STAR <span>SERVER</span></h1>
                    <h3><strong>Welcome Back to Star Server 🚀</strong>
                        Say hello to your refreshed Star Server Customer Panel.
                        Everything you need is right where you left it.
                    </h3>
                    <strong>Everything you know and trust remains the same:</strong>
                    <ul>
                        <li><i class="fa-solid fa-square-check"></i> Your login details remain the same</li>
                        <li><i class="fa-solid fa-square-check"></i> Your products and services are untouched</li>
                        <li><i class="fa-solid fa-square-check"></i> Our support team is still available 24/7</li>
                        <li><i class="fa-solid fa-square-check"></i> Your account remains safe and secure</li>
                    </ul>

                    <p><strong>What’s new:</strong></p>
                    <p>We’ve improved the layout to make things easier to find and more pleasant to use.
                        No surprises — just a smarter, cleaner design.
                    </p>

                    <h6>We’re currently importing data from our previous system. If anything doesn’t look quite
                        right yet, please bear with us. Our team is actively working to complete the transition.
                    </h6>
                </div>
            </div>
        </div>
    </div>


<script>
function moveNext(current,nextFieldId){
    if(current.value.length>=1) document.getElementById(nextFieldId).focus();
}
function movePrev(event,prevFieldId){
    if(event.key==="Backspace" && event.target.value==='') document.getElementById(prevFieldId).focus();
}

// Countdown timer
let duration = 5*60;
let timerInterval = setInterval(function(){
    let minutes = Math.floor(duration/60);
    let seconds = duration%60;
    minutes = minutes<10?"0"+minutes:minutes;
    seconds = seconds<10?"0"+seconds:seconds;
    document.getElementById('timer').textContent = minutes+":"+seconds;
    if(duration-- <=0){
        clearInterval(timerInterval);
        document.querySelectorAll('.otp-inputs input').forEach(el=>el.disabled=true);
        document.querySelector('.otp-message').textContent="OTP expired. Please try again.";
        document.querySelector('.otp-message').classList.remove('success');
    }
},1000);
</script>
</body>
</html>
