<?php
session_start();
include "../includes/db.php";

$message = '';

// Only allow if email is set in session
if (!isset($_SESSION['reset_email'])) {
    header("Location: forgot_password.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = trim($_POST['password']);
    $confirm  = trim($_POST['confirm_password']);

    if($password === '' || $confirm === '') {
        $message = "Please fill all fields.";
    } elseif($password !== $confirm) {
        $message = "Passwords do not match.";
    } else {
        // Hash password
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $email = $_SESSION['reset_email'];

        $stmt = $conn->prepare("UPDATE users SET password=? WHERE email=?");
        $stmt->bind_param("ss", $hashed, $email);
        if($stmt->execute()){
            $message = "Password updated successfully!";
            unset($_SESSION['reset_email']); // clear session
            echo "<script>
                setTimeout(function () {
                    window.location.href = 'userlogin.php';
                }, 2000);
            </script>";
        } else {
            $message = "Database error: " . $stmt->error;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Reset Password</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="../assets/css/style.css">
   
</head>

<body>
    <div class="row">
        <div class="col-md-6">
            <div class="reset_logged">
                <form method="POST">
                    <h2>Reset Your Password</h2>
                    <input type="password" name="password" placeholder="New Password" required> <br>
                    <input type="password" name="confirm_password" placeholder="Confirm Password" required>
                    <button type="submit">Reset Password</button>
                    <?php if($message != ''): ?>
                    <p class="otp-message <?= ($message==='Password updated successfully!')?'success':'' ?>">
                        <?= htmlspecialchars($message) ?>
                    </p>
                    <?php endif; ?>
                </form>
            </div>
        </div>

           <div class="col-md-6">
            <div class="star_col">
                <div class="col_box">
                    <h1>STAR <span>SERVER</span></h1>
                    <h3><strong>Welcome Back to Star Server 🚀</strong>
                        Say hello to your refreshed Star Server Customer Panel.
                        Everything you need is right where you left it.
                    </h3>
                    <strong>Everything you know and trust remains the same:</strong>
                    <ul>
                        <li><i class="fa-solid fa-square-check"></i> Your login details remain the same</li>
                        <li><i class="fa-solid fa-square-check"></i> Your products and services are untouched</li>
                        <li><i class="fa-solid fa-square-check"></i> Our support team is still available 24/7</li>
                        <li><i class="fa-solid fa-square-check"></i> Your account remains safe and secure</li>
                    </ul>

                    <p><strong>What’s new:</strong></p>
                    <p>We’ve improved the layout to make things easier to find and more pleasant to use.
                        No surprises — just a smarter, cleaner design.
                    </p>

                    <h6>We’re currently importing data from our previous system. If anything doesn’t look quite
                        right yet, please bear with us. Our team is actively working to complete the transition.
                    </h6>
                </div>
            </div>
        </div>
    </div>
    </div>
</body>

</html>