<?php
// Detect success redirect
$success = false;

if (isset($_GET['status']) && $_GET['status'] === 'success') {
    $success = true;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Forget Password</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="icon" type="image/png" href="../assets/images/starserver/star-server-favicon.png">

    <!-- Font Awesome -->
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body>
    <div class="row">
        <!-- LEFT -->
        <div class="col-md-6">
            <div class="login_section">

                <!-- ✅ SUCCESS MESSAGE -->
                <?php if ($success): ?>
                    <div class="success-msg">
                        ✅ OTP sent successfully! Please check your email.
                    </div>

                    <script>
                        setTimeout(() => {
                            window.location.href = "verify_otp.php";
                        }, 2000);
                    </script>
                <?php endif; ?>

                <form action="send.php" class="login-form" method="POST">
                    <h1>Star Server</h1>
                    <h2 class="forget_heading">Reset Your Password</h2>

                    <div class="form-group">
                        <label>Email <i class="fa-solid fa-star red-star"></i></label>
                        <input type="email" name="email" placeholder="Enter your email..." required>
                    </div>

                    <button type="submit">Send Verification Code</button>
                </form>
            </div>
        </div>

        <!-- RIGHT -->
        <div class="col-md-6">
            <div class="star_col">
                <div class="col_box">
                    <h1>STAR <span>SERVER</span></h1>
                    <h3>
                        <strong>Welcome Back to Star Server 🚀</strong><br>
                        Say hello to your refreshed Star Server Customer Panel.
                    </h3>

                    <strong>Everything you know and trust remains the same:</strong>
                    <ul>
                        <li><i class="fa-solid fa-square-check"></i> Your login details remain the same</li>
                        <li><i class="fa-solid fa-square-check"></i> Your products and services are untouched</li>
                        <li><i class="fa-solid fa-square-check"></i> Our support team is still available 24/7</li>
                        <li><i class="fa-solid fa-square-check"></i> Your account remains safe and secure</li>
                    </ul>

                    <p><strong>What’s new:</strong></p>
                    <p>
                        We’ve improved the layout to make things easier to find and more pleasant to use.
                        No surprises — just a smarter, cleaner design.
                    </p>

                    <h6>
                        We’re currently importing data from our previous system. If anything doesn’t look quite
                        right yet, please bear with us.
                    </h6>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
