// Js/layout.js
document.addEventListener("DOMContentLoaded", () => {
    // Load Navbar
    fetch("navbar.html")
        .then(response => response.text())
        .then(data => {
            document.getElementById("navbar").innerHTML = data;

            // Make navbar sticky on scroll
            const header = document.querySelector('.navbar_wrapper');
            if (header) {
                window.addEventListener("scroll", () => {
                    if (window.scrollY > 50) {
                        header.classList.add("sticky-header");
                    } else {
                        header.classList.remove("sticky-header");
                    }
                });
            }
        });

    // Load Footer
    fetch("footer.html")
        .then(response => response.text())
        .then(data => {
            document.getElementById("footer").innerHTML = data;
        });
});