<?php
include(__DIR__ . '/../includes/db.php');
include(__DIR__ . '/../includes/header.php');
include(__DIR__ . '/../includes/admin_navbar.php');

if (!isset($_GET['id'])) {
    die("Invalid request");
}

$id = (int)$_GET['id'];

/* Fetch user data */
$result = mysqli_query($conn, "SELECT * FROM hosting_plans WHERE id = $id");
$user = mysqli_fetch_assoc($result);

if (!$user) {
    die("User not found");
}

/* Handle approval */
if (isset($_POST['approve_payment'])) {

    $bandwidth_usage  = mysqli_real_escape_string($conn, $_POST['bandwidth_usage']);
    $server_location  = mysqli_real_escape_string($conn, $_POST['server_location']);
    $total_disk_space = mysqli_real_escape_string($conn, $_POST['total_disk_space']);
    $activated_at     = mysqli_real_escape_string($conn, $_POST['activated_at']);
    $expiry_date      = mysqli_real_escape_string($conn, $_POST['expiry_date']);

    $update = mysqli_query($conn, "
        UPDATE hosting_plans SET
            payment_status   = 'approved',
            bandwidth_usage  = '$bandwidth_usage',
            server_location  = '$server_location',
            total_disk_space = '$total_disk_space',
            activated_at     = '$activated_at',
            expiry_date      = '$expiry_date'
        WHERE id = $id
    ");

    if($update) {
        // Redirect immediately to admin-recent-user-plan.php
        header("Location: ../admin-lg/admin-Recent-userplans.php?success=1");
        exit;
    } else {
        echo "<div class='alert alert-danger'>Error updating hosting plan: ".mysqli_error($conn)."</div>";
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>View User</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{background:#f4f6fb;}
.card-box{
    background:#fff;
    border-radius:14px;
    padding:25px;
    box-shadow:0 10px 20px rgba(0,0,0,.08);
}
.label{
    font-size:12px;
    color:#6b7280;
}
.value{
    font-weight:600;
    color:#111827;
}
.status{
    padding:6px 14px;
    border-radius:20px;
    font-size:12px;
    font-weight:600;
}
.status.pending{background:#fff3cd;color:#856404;}
.status.approved{background:#d1e7dd;color:#0f5132;}
</style>
</head>

<body>

<div class="container my-4">

<a href="../admin-lg/admin-userdeatils.php" class="btn btn-sm btn-secondary mb-3">← Back</a>

<?php if(isset($_GET['success'])): ?>
<div class="alert alert-success">Payment approved & hosting activated successfully.</div>
<?php endif; ?>

<div class="row g-4">

<!-- LEFT : USER DETAILS -->
<div class="col-md-6">
<div class="card-box">

<h5 class="mb-4">User & Hosting Details</h5>

<div class="row g-3">

<div class="col-6">
<div class="label">Full Name</div>
<div class="value"><?= htmlspecialchars($user['fullname']); ?></div>
</div>

<div class="col-6">
<div class="label">Email</div>
<div class="value"><?= htmlspecialchars($user['email']); ?></div>
</div>

<div class="col-6">
<div class="label">Plan</div>
<div class="value"><?= htmlspecialchars($user['plan_name']); ?></div>
</div>

<div class="col-6">
<div class="label">Domain</div>
<div class="value"><?= htmlspecialchars($user['domain_name']); ?></div>
</div>

<div class="col-6">
<div class="label">Amount</div>
<div class="value">₹<?= htmlspecialchars($user['amount']); ?></div>
</div>

<div class="col-6">
<div class="label">Payment Method</div>
<div class="value"><?= htmlspecialchars($user['payment_method']); ?></div>
</div>

<div class="col-6">
<div class="label">Disk Space</div>
<div class="value"><?= htmlspecialchars($user['total_disk_space'] ?? '—'); ?></div>
</div>

<div class="col-6">
<div class="label">Bandwidth</div>
<div class="value"><?= htmlspecialchars($user['bandwidth_usage'] ?? '—'); ?></div>
</div>

<div class="col-6">
<div class="label">Server Location</div>
<div class="value"><?= htmlspecialchars($user['server_location'] ?? '—'); ?></div>
</div>

<div class="col-6">
<div class="label">Expiry Date</div>
<div class="value">
<?= $user['expiry_date'] ? date('d M Y', strtotime($user['expiry_date'])) : '—'; ?>
</div>
</div>

<div class="col-12 mt-2">
<div class="label">Payment Status</div>
<span class="status <?= $user['payment_status']; ?>">
<?= strtoupper($user['payment_status']); ?>
</span>
</div>

</div>
</div>
</div>

<!-- RIGHT : ADMIN FORM -->
<div class="col-md-6">
<div class="card-box">

<h5 class="mb-4">Admin Activation Panel</h5>

<?php if($user['payment_status'] !== 'approved'): ?>
<form method="POST">

<div class="mb-3">
<label class="form-label">Total Disk Space</label>
<input type="text" name="total_disk_space" class="form-control"
placeholder="e.g. 50 GB SSD" required>
</div>

<div class="mb-3">
<label class="form-label">Bandwidth Usage</label>
<input type="text" name="bandwidth_usage" class="form-control"
placeholder="e.g. Unlimited / 2 TB" required>
</div>

<div class="mb-3">
<label class="form-label">Server Location</label>
<select name="server_location" class="form-select" required>
    <option value="">Select Server</option>
    <option>India (Mumbai)</option>
    <option>India (Delhi)</option>
    <option>Singapore</option>
    <option>USA</option>
    <option>Europe</option>
</select>
</div>

<div class="mb-3">
<label class="form-label">Activation Date</label>
<input type="date" name="activated_at" class="form-control" required>
</div>

<div class="mb-3">
<label class="form-label">Expiry Date</label>
<input type="date" name="expiry_date" class="form-control" required>
</div>

<button name="approve_payment" class="btn btn-success w-100">
Approve Payment & Activate
</button>

</form>

<?php else: ?>
<div class="alert alert-info">
Hosting already activated for this user.
</div>
<?php endif; ?>

</div>
</div>

</div>
</div>

</body>
</html>

<?php
include(__DIR__ . '/../includes/footer.php');
?>
