<?php
session_start();
require_once "../includes/db.php";

$message = "";
$message_class = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    $email    = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($email === '' || $password === '') {
        $message = "All fields are required!";
        $message_class = "error-msg";
    } else {

        $sql = "SELECT id, fullname, email, password 
                FROM users 
                WHERE email = ? 
                LIMIT 1";

        $stmt = mysqli_prepare($conn, $sql);

        if (!$stmt) {
            $message = "Database error!";
            $message_class = "error-msg";
        } else {

            mysqli_stmt_bind_param($stmt, "s", $email);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);

            if ($user = mysqli_fetch_assoc($result)) {

                // ✅ CORRECT PASSWORD CHECK
                if (
                    password_verify($password, $user['password']) 
                    || $password === $user['password'] // legacy support
                ) {

                    $_SESSION['user_id']  = $user['id'];
                    $_SESSION['fullname'] = $user['fullname'];
                    $_SESSION['email']    = $user['email'];

                    $message = "Login successful! Redirecting...";
                    $message_class = "success-msg";

                } else {
                    $message = "Invalid password!";
                    $message_class = "error-msg";
                }

            } else {
                $message = "User not found!";
                $message_class = "error-msg";
            }

            mysqli_stmt_close($stmt);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="icon" type="image/png" href="../assets/images/starserver/star-server-favicon.png">
    <!-- Font Awesome 6.5.1 (FREE) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
        crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body>
    <div class="row">
        <div class="col-md-6">
            <div class="login_section">
            <form class="login-form" method="POST">

                <h1>Star Server </h1>
                <h2>Admin Login</h2>

                <?php if ($message !== ""): ?>
                <div class="<?= $message_class ?>">
                    <?= htmlspecialchars($message) ?>
                </div>
                <?php endif; ?>

                <?php if ($message_class === "success-msg"): ?>
                <script>
                    setTimeout(() => {
                        window.location.href = "admin_dashboard.php";
                    }, 2000);
                </script>
                <?php endif; ?>

                <div class="form-group">
                    <label>Email <i class="fa-solid fa-star red-star"></i></label>
                    <input type="email" name="email" required>
                </div>

                <div class="form-group">
                    <label>Password <i class="fa-solid fa-star red-star"></i></label>
                    <input type="password" name="password" required>
                </div>

                <button type="submit">Login</button>

                <div class="login-links">
                    <p>Don’t have an account? <a href="user-registration.php">Register</a></p>
                    <p><a href="forget_password.php">Forgot Password?</a></p>
                </div>

            </form>
            </div>
        </div>

        <div class="col-md-6">
            <div class="star_col">
                <div class="col_box">
                    <h1>STAR <span>SERVER</span></h1>
                    <h3><strong>Welcome Back to Star Server 🚀</strong>
                        Say hello to your refreshed Star Server Customer Panel.
                        Everything you need is right where you left it.
                    </h3>
                    <strong>Everything you know and trust remains the same:</strong>
                    <ul>
                        <li><i class="fa-solid fa-square-check"></i> Your login details remain the same</li>
                        <li><i class="fa-solid fa-square-check"></i> Your products and services are untouched</li>
                        <li><i class="fa-solid fa-square-check"></i> Our support team is still available 24/7</li>
                        <li><i class="fa-solid fa-square-check"></i> Your account remains safe and secure</li>
                    </ul>

                    <p><strong>What’s new:</strong></p>
                    <p>We’ve improved the layout to make things easier to find and more pleasant to use.
                        No surprises — just a smarter, cleaner design.
                    </p>

                    <h6>We’re currently importing data from our previous system. If anything doesn’t look quite
                        right yet, please bear with us. Our team is actively working to complete the transition.
                    </h6>
                </div>
            </div>
        </div>
    </div>

</body>

</html>