<?php
include(__DIR__ . '/../includes/db.php');
include(__DIR__ . '/../includes/header.php');
include(__DIR__ . '/../includes/admin_navbar.php');

/* ---------- Pagination Logic ---------- */
$limit = 5;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = ($page < 1) ? 1 : $page;
$offset = ($page - 1) * $limit;

$totalQuery = mysqli_query($conn, "SELECT COUNT(*) AS total FROM hosting_plans");
$totalRow = mysqli_fetch_assoc($totalQuery);
$totalRecords = $totalRow['total'];
$totalPages = ceil($totalRecords / $limit);

$query = "SELECT * FROM hosting_plans ORDER BY id DESC LIMIT $limit OFFSET $offset";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Admin User Details</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background:#f4f6fb;
    font-family: "Inter", sans-serif;
}

/* Layout */
.admin-user-layout{
    padding:20px;
    min-height:100vh;
}
.page-title-heading{
    font-size:18px;
    font-weight:600;
    margin-bottom:15px;
}

/* Toolbar */
.user-toolbar{
    display:flex;
    gap:10px;
    margin-bottom:15px;
}
.user-toolbar input,
.user-toolbar select{
    font-size:13px;
}

/* Table Box */
.user-table-wrapper{
    background:#fff;
    border-radius:10px;
    padding:15px;
    box-shadow:0 6px 15px rgba(0,0,0,.05);
}

/* Table */
.user-table{
    font-size:13px;
}
.user-table thead{
    background:#f1f3f6;
}
.user-table th{
    font-weight:600;
    color:#444;
    white-space:nowrap;
}
.user-table td{
    vertical-align:middle;
}

/* Status */
.status{
    font-size:11px;
    padding:4px 10px;
    border-radius:20px;
    font-weight:600;
}
.status.active{
    background:#e7f8ef;
    color:#1e9e63;
}
.status.inactive{
    background:#fdecec;
    color:#d73737;
}

/* Buttons */
.action-buttons a{
    font-size:11px;
    padding:4px 8px;
    border-radius:6px;
    text-decoration:none;
    color:#fff;
}
.btn-view{background:#4f46e5;}
.btn-edit{background:#f59e0b;}

/* Pagination */
.pagination-wrapper{
    margin-top:20px;
    display:flex;
    justify-content:center;
}
.pagination{
    list-style:none;
    display:flex;
    gap:6px;
    padding:0;
}
.pagination li a{
    padding:6px 10px;
    font-size:12px;
    border-radius:6px;
    background:#eaeaea;
    color:#333;
    text-decoration:none;
}
.pagination li.active a{
    background:#4f46e5;
    color:#fff;
}

/* Responsive */
@media(max-width:768px){
    .user-toolbar{flex-direction:column;}
    .user-table thead{display:none;}
    .user-table, .user-table tbody, .user-table tr, .user-table td{
        display:block;
        width:100%;
    }
    .user-table tr{
        border:1px solid #eee;
        border-radius:10px;
        padding:10px;
        margin-bottom:10px;
    }
    .user-table td{
        display:flex;
        justify-content:space-between;
        font-size:12px;
        border:none;
    }
    .user-table td::before{
        content:attr(data-label);
        font-weight:600;
        color:#555;
    }
}
</style>
</head>

<body>

<div class="admin-user-layout">
<div class="admin-user-content">

<h3 class="page-title-heading">User Details</h3>

<div class="user-toolbar">
    <input type="text" class="form-control" placeholder="Search user...">
    <select class="form-select">
        <option>All Users</option>
        <option>Active</option>
        <option>Inactive</option>
    </select>
</div>

<div class="table-responsive user-table-wrapper">
<table class="table user-table align-middle">
<thead>
<tr>
    <th>sl.</th>
    <th>User</th>
    <th>Email</th>
    <th>Plan</th>
    <th>Domain</th>
    <th>Registered</th>
    <th>Expiry</th>
    <th>Action</th>
</tr>
</thead>

<tbody>
<?php
if(mysqli_num_rows($result) > 0){
    $i = $offset + 1;
    while($row = mysqli_fetch_assoc($result)){
?>
<tr>
<td data-label="#"><?= $i++; ?></td>
<td data-label="User"><?= htmlspecialchars($row['fullname']); ?></td>
<td data-label="Email"><?= htmlspecialchars($row['email']); ?></td>
<td data-label="Plan"><?= htmlspecialchars($row['plan_name']); ?></td>
<td data-label="Domain"><?= htmlspecialchars($row['domain_name']); ?></td>

<td data-label="Registered"><?= date('d M Y', strtotime($row['created_at'])); ?></td>
<td data-label="Expiry"><?= date('d M Y', strtotime($row['expiry_date'])); ?></td>
<td data-label="Action">
    <div class="action-buttons d-flex gap-1">
        <a href="../admin-lg/view_user.php?id=<?= (int)$row['id']; ?>" class="btn-view">View</a>
    </div>
</td>
</tr>
<?php }} else { ?>
<tr><td colspan="9" class="text-center">No records found</td></tr>
<?php } ?>
</tbody>
</table>
</div>

<!-- Pagination -->
<div class="pagination-wrapper">
<ul class="pagination">
<?php if($page > 1): ?>
<li><a href="?page=<?= $page-1 ?>">«</a></li>
<?php endif; ?>

<?php for($p=1;$p<=$totalPages;$p++): ?>
<li class="<?= ($p==$page)?'active':'' ?>">
<a href="?page=<?= $p ?>"><?= $p ?></a>
</li>
<?php endfor; ?>

<?php if($page < $totalPages): ?>
<li><a href="?page=<?= $page+1 ?>">»</a></li>
<?php endif; ?>
</ul>
</div>

</div>
</div>

</body>
</html>

<?php
include(__DIR__ . '/../includes/footer.php');
include(__DIR__ . '/../includes/scripts.php');
?>
