<?php
session_start();
require_once(__DIR__ . '/../includes/db.php');

/* ===============================
   FETCH PENDING UPDATE REQUESTS
================================ */
$sql = "
SELECT 
    hpu.id AS update_id,
    hpu.new_plan_name,
    hpu.request_type,
    hpu.requested_at,
    u.fullname AS user_name,
    u.email,
    hp.domain_name,
    hp.plan_name AS old_plan
FROM hosting_plan_updates hpu
INNER JOIN users u ON u.id = hpu.user_id
INNER JOIN hosting_plans hp ON hp.id = hpu.old_plan_id
WHERE hpu.status = ?
ORDER BY hpu.requested_at DESC
";

$status = 'pending';
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $status);
$stmt->execute();
$result = $stmt->get_result();

include('../includes/admin-header.php');
include('../includes/admin-navbar.php');
?>

<div class="container my-5">
    <h3 class="mb-4 fw-bold text-primary">
        🔄 Hosting Plan Update Requests
    </h3>

    <?php if ($result && $result->num_rows > 0): ?>
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle text-center">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>User</th>
                        <th>Email</th>
                        <th>Domain</th>
                        <th>Current Plan</th>
                        <th>Requested Plan</th>
                        <th>Type</th>
                        <th>Requested On</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php $i = 1; while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++; ?></td>

                        <td><?= htmlspecialchars($row['user_name']); ?></td>

                        <td><?= htmlspecialchars($row['email']); ?></td>

                        <td><?= htmlspecialchars($row['domain_name']); ?></td>

                        <td>
                            <span class="badge bg-secondary">
                                <?= htmlspecialchars($row['old_plan']); ?>
                            </span>
                        </td>

                        <td>
                            <span class="badge bg-success">
                                <?= htmlspecialchars($row['new_plan_name']); ?>
                            </span>
                        </td>

                        <td>
                            <span class="badge bg-warning text-dark">
                                <?= ucfirst(htmlspecialchars($row['request_type'])); ?>
                            </span>
                        </td>

                        <td>
                            <?= date('d M Y', strtotime($row['requested_at'])); ?>
                        </td>

                        <td>
                            <form action="process-update-plan.php" method="POST" class="d-inline">
                                <input type="hidden" name="update_id" value="<?= (int)$row['update_id']; ?>">
                                <input type="hidden" name="action" value="approve">
                                <button class="btn btn-success btn-sm"
                                    onclick="return confirm('Approve this plan update?')">
                                    Approve
                                </button>
                            </form>

                            <form action="process-update-plan.php" method="POST" class="d-inline">
                                <input type="hidden" name="update_id" value="<?= (int)$row['update_id']; ?>">
                                <input type="hidden" name="action" value="reject">
                                <button class="btn btn-danger btn-sm"
                                    onclick="return confirm('Reject this plan update?')">
                                    Reject
                                </button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-info text-center">
            No pending hosting plan update requests.
        </div>
    <?php endif; ?>
</div>

<?php include('../includes/admin-footer.php'); ?>
