<?php
include(__DIR__ . '/../includes/db.php');
include(__DIR__ . '/../includes/header.php');
include(__DIR__ . '/../includes/admin_navbar.php');

// Handle admin reply
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reply'])) {
    $ticket_id = intval($_POST['ticket_id']);
    $reply     = mysqli_real_escape_string($conn, $_POST['admin_reply']);
    $status    = $_POST['status'];

    mysqli_query($conn,"UPDATE support_tickets SET admin_reply='$reply', status='$status' WHERE id='$ticket_id'");
}
?>

<style>
.support-page{max-width:1100px;margin:auto;padding:30px 15px}
.page-title{text-align:center;font-weight:700;margin-bottom:25px}
.ticket-tabs{display:flex;justify-content:center;gap:10px;margin-bottom:25px}
.ticket-tabs button{border:none;padding:10px 26px;border-radius:25px;background:#e9ecef;font-weight:600;cursor:pointer;transition:.3s}
.ticket-tabs button.active,.ticket-tabs button:hover{background:#0d6efd;color:#fff}
.ticket-card{background:#fff;border-radius:14px;padding:20px;margin-bottom:18px;box-shadow:0 10px 30px rgba(0,0,0,.06)}
.ticket-card h6{font-weight:600;margin-bottom:6px}
.ticket-card p{font-size:13px;color:#6c757d}
.ticket-status{padding:6px 15px;border-radius:20px;font-size:13px;font-weight:600}
.ticket-status.open{background:#e7f1ff;color:#0d6efd}
.ticket-status.closed{background:#e6f7ef;color:#198754}
.ticket-card textarea{width:100%;min-height:80px;border-radius:10px;padding:10px;border:1px solid #ddd;resize:none;margin-top:10px}
.ticket-card select{margin-top:10px;padding:8px 12px;border-radius:20px;border:1px solid #ddd}
.ticket-card button{margin-top:10px;background:#0d6efd;color:#fff;border:none;padding:8px 22px;border-radius:22px;font-weight:600;cursor:pointer}
.admin-reply{background:#f1f3f5;padding:12px;border-radius:10px;margin-top:10px;font-size:14px}
</style>

<div class="container support-page">
<h2 class="page-title">Admin Support Tickets</h2>

<div class="ticket-tabs">
    <button class="active" onclick="showTab('open',this)">Open Tickets</button>
    <button onclick="showTab('closed',this)">Closed Tickets</button>
</div>

<!-- OPEN TICKETS -->
<div id="open" class="ticket-section">
<?php
$open=mysqli_query($conn,"SELECT * FROM support_tickets WHERE status='Open' ORDER BY created_at DESC");
if(mysqli_num_rows($open)){
    while($t=mysqli_fetch_assoc($open)){
?>
<div class="ticket-card">
    <h6><?= htmlspecialchars($t['message']) ?></h6>
    <p><?= htmlspecialchars($t['user_name']) ?> | <?= htmlspecialchars($t['user_email']) ?> • <?= date('d M Y',strtotime($t['created_at'])) ?></p>

    <form method="POST">
        <textarea name="admin_reply" required placeholder="Write reply to user..."><?= htmlspecialchars($t['admin_reply']) ?></textarea>
        <input type="hidden" name="ticket_id" value="<?= $t['id'] ?>">
        <select name="status">
            <option value="Open" <?= $t['status']=='Open'?'selected':'' ?>>Keep Open</option>
            <option value="Closed" <?= $t['status']=='Closed'?'selected':'' ?>>Close Ticket</option>
        </select>
        <button type="submit" name="reply">Send Reply</button>
    </form>
</div>
<?php
    }
}else{
    echo '<p class="text-center mt-4">No open tickets.</p>';
}
?>
</div>

<!-- CLOSED TICKETS -->
<div id="closed" class="ticket-section" style="display:none;">
<?php
$closed=mysqli_query($conn,"SELECT * FROM support_tickets WHERE status='Closed' ORDER BY created_at DESC");
if(mysqli_num_rows($closed)){
    while($t=mysqli_fetch_assoc($closed)){
?>
<div class="ticket-card">
    <h6><?= htmlspecialchars($t['message']) ?></h6>
    <p><?= htmlspecialchars($t['user_name']) ?> | <?= htmlspecialchars($t['user_email']) ?> • <?= date('d M Y',strtotime($t['created_at'])) ?></p>
    <?php if(!empty($t['admin_reply'])){ ?>
    <div class="admin-reply"><strong>Admin Reply:</strong><p><?= htmlspecialchars($t['admin_reply']) ?></p></div>
    <?php } ?>
    <span class="ticket-status closed">Closed</span>
</div>
<?php
    }
}else{
    echo '<p class="text-center mt-4">No closed tickets.</p>';
}
?>
</div>

</div>

<script>
function showTab(tab,btn){
    document.getElementById('open').style.display='none';
    document.getElementById('closed').style.display='none';
    document.getElementById(tab).style.display='block';
    document.querySelectorAll('.ticket-tabs button').forEach(b=>b.classList.remove('active'));
    btn.classList.add('active');
}
</script>

<?php
include(__DIR__ . '/../includes/footer.php');
include(__DIR__ . '/../includes/scripts.php');
?>
