
<?php
include(__DIR__ . '/../includes/db.php');
include(__DIR__ . '/../includes/header.php');
include(__DIR__ . '/../includes/admin_navbar.php');

/* ---------- Pagination ---------- */
$limit = 10;
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$page = ($page < 1) ? 1 : $page;
$offset = ($page - 1) * $limit;

/* Count total approved plans */
$totalQuery = mysqli_query($conn, "SELECT COUNT(*) AS total FROM hosting_plans WHERE payment_status='approved'");
$totalRecords = mysqli_fetch_assoc($totalQuery)['total'];
$totalPages = ceil($totalRecords / $limit);

/* Fetch approved plans only */
$result = mysqli_query($conn, "SELECT * FROM hosting_plans WHERE payment_status='approved' ORDER BY id DESC LIMIT $limit OFFSET $offset");
?>

<div class="container my-4">
<h3>Admin - Recently Approved User Hosting Plans</h3>

<?php if(isset($_GET['success'])): ?>
<div class="alert alert-success">Payment approved & hosting activated successfully.</div>
<?php endif; ?>

<div class="table-responsive mt-3">
<table class="table table-bordered table-hover">
<thead class="table-light">
<tr>
    <th>#</th>
    <th>Full Name</th>
    <th>Email</th>
    <th>Plan</th>
    <th>Domain</th>
    <th>Amount</th>
    <th>Activated At</th>
    <th>Expiry Date</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php
$counter = $offset + 1;
if(mysqli_num_rows($result) > 0):
    while($row = mysqli_fetch_assoc($result)):
?>
<tr>
    <td><?= $counter++; ?></td>
    <td><?= htmlspecialchars($row['fullname']); ?></td>
    <td><?= htmlspecialchars($row['email']); ?></td>
    <td><?= htmlspecialchars($row['plan_name']); ?></td>
    <td><?= htmlspecialchars($row['domain_name']); ?></td>
    <td>₹<?= htmlspecialchars($row['amount']); ?></td>
    <td><?= $row['activated_at'] ? date('d M Y', strtotime($row['activated_at'])) : '—'; ?></td>
    <td><?= $row['expiry_date'] ? date('d M Y', strtotime($row['expiry_date'])) : '—'; ?></td>
    <td><a href="view_user.php?id=<?= $row['id']; ?>" class="btn btn-sm btn-primary">View</a></td>
</tr>
<?php
    endwhile;
else:
?>
<tr><td colspan="9" class="text-center">No approved plans found.</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>

<!-- Pagination -->
<?php if($totalPages > 1): ?>
<div class="d-flex justify-content-center mt-3">
<ul class="pagination">
<?php if($page > 1): ?>
<li class="page-item"><a class="page-link" href="?page=<?= $page-1 ?>">«</a></li>
<?php endif; ?>

<?php for($p=1; $p <= $totalPages; $p++): ?>
<li class="page-item <?= ($p==$page)?'active':'' ?>">
    <a class="page-link" href="?page=<?= $p ?>"><?= $p ?></a>
</li>
<?php endfor; ?>

<?php if($page < $totalPages): ?>
<li class="page-item"><a class="page-link" href="?page=<?= $page+1 ?>">»</a></li>
<?php endif; ?>
</ul>
</div>
<?php endif; ?>

</div>

<?php include(__DIR__ . '/../includes/footer.php'); ?>
